using System.IO;
using System.Reflection;
using GrapeCity.Documents.Excel;
using System;

namespace GrapeCity.Documents.Excel.Examples.Features.HtmlExporting.SaveWorksheetToSingleHtml
{
    class Program
    {
        static void Main(string[] args)
        {
			// Create an html file stream
			FileStream outputStream = new FileStream("SaveWorksheetToSingleHtml.html", FileMode.Create);
			
			//create a new workbook
			var workbook = new GrapeCity.Documents.Excel.Workbook();
			
			Stream fileStream = GetResourceStream("xlsx\\BreakEven.xlsx");
			workbook.Open(fileStream);
			
			HtmlSaveOptions options = new HtmlSaveOptions();
			
			// Export first sheet
			options.ExportSheetName = workbook.Worksheets[0].Name;
			
			// Set exported image as base64
			options.ExportImageAsBase64 = true;
			
			// Set exported css style in html file
			options.CssExportType = CssExportType.Internal;
			
			// Set not to export single tab in html
			options.ExportSingleTab = false;
			
			workbook.Save(outputStream, options);
			        
			// Close the html stream
			outputStream.Close();

        }

		static Stream GetResourceStream(string resourcePath)
        {
            string resource = "SaveWorksheetToSingleHtml.Resource." + resourcePath.Replace("\\", ".");
            var assembly = typeof(Program).GetTypeInfo().Assembly;
            return assembly.GetManifestResourceStream(resource);
        }

    }
}