import java.util.*
import com.grapecity.documents.excel.*
import com.grapecity.documents.excel.drawing.*


fun main(args: Array<String>?) {
	// Create a new workbook
	var workbook = Workbook()
	
	
	//-----------------------------Set Value------------------------------
	var sourceData = arrayOf(
	    arrayOf<Any>("ITEM", "AMOUNT"),
	    arrayOf<Any>("Income 1", 2500),
	    arrayOf<Any>("Income 2", 1000),
	    arrayOf<Any>("Income 3", 250),
	    arrayOf<Any>("Other", 250)
	)
	val sourceData1 = arrayOf(
	    arrayOf<Any>("ITEM", "AMOUNT"),
	    arrayOf<Any>("Rent/mortgage", 800),
	    arrayOf<Any>("Electricity", 120),
	    arrayOf<Any>("Gas", 50),
	    arrayOf<Any>("Cell phone", 45),
	    arrayOf<Any>("Groceries", 500),
	    arrayOf<Any>("Car payment", 273),
	    arrayOf<Any>("Auto expenses", 120),
	    arrayOf<Any>("Student loans", 50),
	    arrayOf<Any>("Credit cards", 100),
	    arrayOf<Any>("Auto insurance", 78),
	    arrayOf<Any>("Personal care", 50),
	    arrayOf<Any>("Entertainment", 100),
	    arrayOf<Any>("Miscellaneous", 50)
	)
	val worksheet: IWorksheet = workbook.getWorksheets().get(0)
	worksheet.getRange("B3:C7").value = sourceData
	worksheet.getRange("B10:C23").value = sourceData1
	worksheet.name = "Tables"
	worksheet.getRange("B2:C2").merge()
	worksheet.getRange("B2").value = "MONTHLY INCOME"
	worksheet.getRange("B9:C9").merge()
	worksheet.getRange("B9").value = "MONTHLY EXPENSES"
	worksheet.getRange("E2:G2").merge()
	worksheet.getRange("E2").value = "PERCENTAGE OF INCOME SPENT"
	worksheet.getRange("E5:G5").merge()
	worksheet.getRange("E5").value = "SUMMARY"
	worksheet.getRange("E3:F3").merge()
	worksheet.getRange("E9").value = "BALANCE"
	worksheet.getRange("E6").value = "Total Monthly Income"
	worksheet.getRange("E7").value = "Total Monthly Expenses"
	
	//--------------------------------Set Height & Width--------------------------------
	worksheet.standardHeight = 26.25
	worksheet.standardWidth = 8.43
	worksheet.getRange("2:24").rowHeight = 27.0
	worksheet.getRange("A:A").columnWidth = 2.855
	worksheet.getRange("B:B").columnWidth = 33.285
	worksheet.getRange("C:C").columnWidth = 25.57
	worksheet.getRange("D:D").columnWidth = 1.0
	worksheet.getRange("E:F").columnWidth = 25.57
	worksheet.getRange("G:G").columnWidth = 14.285
	
	//------------------------------Set Table--------------------------------------
	// Create the first table to show Income
	val incomeTable: ITable = worksheet.tables.add(worksheet.getRange("B3:C7"), true)
	incomeTable.name = "tblIncome"
	incomeTable.tableStyle = workbook.tableStyles.get("TableStyleMedium4")
	
	// Create the second table to show Expenses
	val expensesTable: ITable = worksheet.tables.add(worksheet.getRange("B10:C23"), true)
	expensesTable.name = "tblExpenses"
	expensesTable.tableStyle = workbook.tableStyles.get("TableStyleMedium4")
	
	//------------------------------Set Formulas-----------------------------------
	worksheet.names.add("TotalMonthlyIncome", "=SUM(tblIncome[AMOUNT])")
	worksheet.names.add("TotalMonthlyExpenses", "=SUM(tblExpenses[AMOUNT])")
	worksheet.getRange("E3").formula = "=TotalMonthlyExpenses"
	worksheet.getRange("G3").formula = "=TotalMonthlyExpenses/TotalMonthlyIncome"
	worksheet.getRange("G6").formula = "=TotalMonthlyIncome"
	worksheet.getRange("G7").formula = "=TotalMonthlyExpenses"
	worksheet.getRange("G9").formula = "=TotalMonthlyIncome-TotalMonthlyExpenses"
	
	//----------------------------Set Styles-------------------------
	val currencyStyle: IStyle = workbook.styles.get("Currency")
	currencyStyle.includeAlignment = true
	currencyStyle.horizontalAlignment = HorizontalAlignment.Left
	currencyStyle.verticalAlignment = VerticalAlignment.Bottom
	currencyStyle.numberFormat = "$#,##0.00"
	val heading1Style: IStyle = workbook.styles.get("Heading 1")
	heading1Style.includeAlignment = true
	heading1Style.horizontalAlignment = HorizontalAlignment.Center
	heading1Style.verticalAlignment = VerticalAlignment.Center
	heading1Style.includeFont = true
	heading1Style.font.name = "Century Gothic"
	heading1Style.font.bold = true
	heading1Style.font.size = 11.0
	heading1Style.font.color = Color.GetWhite()
	heading1Style.includeBorder = false
	heading1Style.includePatterns = true
	heading1Style.interior.color = Color.FromArgb(255, 32, 61, 64)
	val percentStyle: IStyle = workbook.styles.get("Percent")
	percentStyle.includeAlignment = true
	percentStyle.horizontalAlignment = HorizontalAlignment.Center
	percentStyle.includeFont = true
	percentStyle.font.color = Color.FromArgb(255, 32, 61, 64)
	percentStyle.font.name = "Century Gothic"
	percentStyle.font.bold = true
	percentStyle.font.size = 14.0
	worksheet.getSheetView().setDisplayGridlines(false)
	worksheet.getRange("C4:C7, C11:C23, G6:G7, G9").style = currencyStyle
	worksheet.getRange("B2, B9, E2, E5").style = heading1Style
	worksheet.getRange("G3").style = percentStyle
	worksheet.getRange("E6:G6").borders.get(BordersIndex.EdgeBottom).lineStyle = BorderLineStyle.Medium
	worksheet.getRange("E6:G6").borders.get(BordersIndex.EdgeBottom).color = Color.FromArgb(255, 32, 61, 64)
	worksheet.getRange("E7:G7").borders.get(BordersIndex.EdgeBottom).lineStyle = BorderLineStyle.Medium
	worksheet.getRange("E7:G7").borders.get(BordersIndex.EdgeBottom).color = Color.FromArgb(255, 32, 61, 64)
	worksheet.getRange("E9:G9").interior.color = Color.FromArgb(255, 32, 61, 64)
	worksheet.getRange("E9:G9").horizontalAlignment = HorizontalAlignment.Left
	worksheet.getRange("E9:G9").verticalAlignment = VerticalAlignment.Center
	worksheet.getRange("E9:G9").font.name = "Century Gothic"
	worksheet.getRange("E9:G9").font.bold = true
	worksheet.getRange("E9:G9").font.size = 11.0
	worksheet.getRange("E9:G9").font.color = Color.GetWhite()
	worksheet.getRange("E3:F3").borders.color = Color.FromArgb(255, 32, 61, 64)
	
	//----------------------------Set Conditional Format-------------------------
	val dataBar: IDataBar = worksheet.getRange("E3").formatConditions.addDatabar()
	dataBar.minPoint.type = ConditionValueTypes.Number
	dataBar.minPoint.value = 1
	dataBar.maxPoint.type = ConditionValueTypes.Number
	dataBar.maxPoint.value = "=TotalMonthlyIncome"
	dataBar.barFillType = DataBarFillType.Gradient
	dataBar.barColor.color = Color.GetRed()
	dataBar.showValue = false
	
	//--------------------------------Create pivot table--------------------------------
	val worksheet2: IWorksheet = workbook.worksheets.add()
	worksheet2.name = "Pivot Table"
	sourceData = arrayOf(
	    arrayOf("Order ID", "Product", "Category", "Amount", "Date", "Country"),
	    arrayOf(1, "Carrots", "Vegetables", 4270, GregorianCalendar(2022, 9, 6), "United States"),
	    arrayOf(2, "Broccoli", "Vegetables", 8239, GregorianCalendar(2022, 8, 7), "United States"),
	    arrayOf(3, "Banana", "Fruit", 617, GregorianCalendar(2022, 10, 18), "United States"),
	    arrayOf(4, "Banana", "Fruit", 8384, GregorianCalendar(2022, 11, 10), "Canada"),
	    arrayOf(5, "Beans", "Vegetables", 2626, GregorianCalendar(2022, 10, 10), "Germany"),
	    arrayOf(6, "Orange", "Fruit", 3610, GregorianCalendar(2022, 11, 11), "United States"),
	    arrayOf(7, "Broccoli", "Vegetables", 9062, GregorianCalendar(2022, 10, 11), "Australia"),
	    arrayOf(8, "Banana", "Fruit", 6906, GregorianCalendar(2022, 10, 16), "New Zealand"),
	    arrayOf(9, "Apple", "Fruit", 2417, GregorianCalendar(2022, 11, 16), "France"),
	    arrayOf(10, "Apple", "Fruit", 7431, GregorianCalendar(2022, 11, 16), "Canada"),
	    arrayOf(11, "Banana", "Fruit", 8250, GregorianCalendar(2022, 10, 16), "Germany"),
	    arrayOf(12, "Broccoli", "Vegetables", 7012, GregorianCalendar(2022, 10, 18), "United States"),
	    arrayOf(13, "Carrots", "Vegetables", 1903, GregorianCalendar(2022, 11, 20), "Germany"),
	    arrayOf(14, "Broccoli", "Vegetables", 2824, GregorianCalendar(2022, 9, 24), "Canada"),
	    arrayOf(15, "Apple", "Fruit", 6946, GregorianCalendar(2022, 11, 24), "France")
	)
	worksheet2.getRange("A1:F16").value = sourceData
	worksheet2.getRange("A:F").columnWidth = 15.0
	val pivotCache: IPivotCache = workbook.pivotCaches.create(worksheet2.getRange("A1:F16"))
	val pivotTable: IPivotTable =
	    worksheet2.pivotTables.add(pivotCache, worksheet2.getRange("H7"), "pivotTable1")
	
	//--------------------------------Configure pivot table's fields--------------------------------
	val fieldCategory: IPivotField = pivotTable.pivotFields.get("Category")
	fieldCategory.orientation = PivotFieldOrientation.RowField
	val fieldProduct: IPivotField = pivotTable.pivotFields.get("Product")
	fieldProduct.orientation = PivotFieldOrientation.ColumnField
	val fieldAmount: IPivotField = pivotTable.pivotFields.get("Amount")
	fieldAmount.orientation = PivotFieldOrientation.DataField
	fieldAmount.numberFormat = "$#,##0"
	val fieldCountry: IPivotField = pivotTable.pivotFields.get("Country")
	fieldCountry.orientation = PivotFieldOrientation.PageField
	
	//--------------------------------Add chart--------------------------------
	val worksheet3: IWorksheet = workbook.worksheets.add()
	worksheet3.name = "Chart"
	val shape: IShape = worksheet3.shapes.addChart(ChartType.ColumnClustered, 300.0, 10.0, 300.0, 300.0)
	shape.chart.chartTitle.text = "Sales Increases Over Previous Quarter"
	worksheet3.getRange("A1:D6").value =
	    arrayOf(
	        arrayOf(null, "Q1", "Q2", "Q3"),
	        arrayOf("Belgium", 10, 25, 25),
	        arrayOf("France", -51, -36, 27),
	        arrayOf("Greece", 52, -85, -30),
	        arrayOf("Italy", 22, 65, 65),
	        arrayOf("UK", 23, 69, 69)
	    )
	shape.chart.seriesCollection.add(worksheet3.getRange("A1:D6"), RowCol.Columns, true, true)
	worksheet3.getRange("B1:D1").horizontalAlignment = HorizontalAlignment.Right
	worksheet3.getRange("B1:D1").font.bold = true
	worksheet3.getRange("B2:D6").numberFormat = "€#,##0"
	val valueAxis: IAxis = shape.chart.axes.item(AxisType.Value)
	valueAxis.tickLabels.numberFormat = "€#,##0"
	
	workbook.save("Tutorial.xlsx")
	    

}


